"""
Test module for expression module.
"""
from calculator.expression import TermExpression, OperatorExpression
from calculator.operators import Operator

def test_single_term():
    """
    Test the TermExpression class.
    """
    expression = TermExpression(42)
    assert repr(expression) == '42'
    assert expression() == 42


def test_single_operator():
    """
    Test the OperatorExpression class.
    """
    add = Operator('+', 1, lambda a, b: a + b)
    expression = OperatorExpression(add, TermExpression(1), TermExpression(2))
    assert repr(expression) == '(1 + 2)'
    assert expression() == 3


def test_complex_expression():
    """
    Test a complex expression.
    """
    add = Operator('+', 1, lambda a, b: a + b)
    multiply = Operator('*', 2, lambda a, b: a * b)
    expression = OperatorExpression(
        multiply,
        OperatorExpression(add, TermExpression(1), TermExpression(2)),
        TermExpression(3)
    )
    assert repr(expression) == '((1 + 2) * 3)'
    assert expression() == 9
