# Generated by Django 2.0.7 on 2018-09-11 17:38

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import markdownx.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('profiles', '0001_initial'),
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Participation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('submitted', models.DateTimeField(auto_now_add=True, help_text='Date de soumission de la participation', null=True, verbose_name='soumis le')),
                ('accepted', models.NullBooleanField(help_text='Cocher pour confirmer au tutoré sa participation à la sortie.', verbose_name='accepté')),
                ('present', models.NullBooleanField(help_text='Une fois la sortie passée, indiquer si le lycéen était présent.', verbose_name='présent')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='participations', to=settings.AUTH_USER_MODEL, verbose_name='utilisateur')),
            ],
            options={
                'verbose_name': 'participation',
                'ordering': ('-submitted',),
            },
        ),
        migrations.CreateModel(
            name='Place',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, verbose_name='nom')),
                ('description', markdownx.models.MarkdownxField(blank=True, default='', help_text="Une description de ce lieu : de quoi s'agit-il ? Ce champ supporte Markdown.")),
                ('address', models.ForeignKey(help_text='Adresse complète de ce lieu', null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Address', verbose_name='adresse')),
            ],
            options={
                'verbose_name': 'lieu',
                'verbose_name_plural': 'lieux',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Visit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Préciser si besoin le type de sortie (exposition, concert…) ', max_length=100, verbose_name='titre')),
                ('summary', models.CharField(blank=True, default='', help_text='Une ou deux phrases décrivant la sortie de manière attrayante.', max_length=300, verbose_name='résumé')),
                ('description', markdownx.models.MarkdownxField(blank=True, default='', help_text='Une description plus complète des activités proposées durant la sortie. Ce champ supporte Markdown.')),
                ('date', models.DateField(help_text='Date de la sortie.')),
                ('start_time', models.TimeField(help_text='Heure de début de la sortie. Format : hh:mm.', verbose_name='heure de début')),
                ('end_time', models.TimeField(help_text='Heure de fin de la sortie. Format : hh:mm.', verbose_name='heure de fin')),
                ('meeting', models.CharField(blank=True, default='', help_text='Indiquez aux tutorés où ils devront vous retrouver. Exemple : "devant le musée".', max_length=100, verbose_name='lieu de rendez-vous')),
                ('deadline', models.DateTimeField(help_text="Note : les lycéens ne pourront plus s'inscrire passée cette date. Format de l'heure : hh:mm.", verbose_name="date limite d'inscription")),
                ('image', models.ImageField(blank=True, help_text='Une illustration représentative de la sortie.', null=True, upload_to='visits/images/', verbose_name='illustration')),
                ('fact_sheet', models.FileField(blank=True, help_text='Informe le lycéen de détails sur la sortie. Tous formats supportés, PDF recommandé.', null=True, upload_to='visits/fact_sheets/', verbose_name='fiche sortie')),
                ('permission', models.FileField(blank=True, help_text='À mettre à disposition pour que le lycéen la remplisse. Tout format supporté, PDF recommandé.', null=True, upload_to='visits/visit_permissions/', verbose_name='autorisation de sortie')),
            ],
            options={
                'verbose_name': 'sortie',
                'ordering': ('date',),
            },
        ),
        migrations.CreateModel(
            name='VisitOrganizer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tutor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='profiles.Tutor', verbose_name='tuteur')),
                ('visit', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='visits.Visit', verbose_name='sortie')),
            ],
            options={
                'verbose_name': 'organisateur',
            },
        ),
        migrations.AddField(
            model_name='visit',
            name='organizers',
            field=models.ManyToManyField(related_name='organized_visits', through='visits.VisitOrganizer', to='profiles.Tutor'),
        ),
        migrations.AddField(
            model_name='visit',
            name='participants',
            field=models.ManyToManyField(through='visits.Participation', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='visit',
            name='place',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='visits.Place', verbose_name='lieu'),
        ),
        migrations.AddField(
            model_name='participation',
            name='visit',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='participations', to='visits.Visit', verbose_name='sortie'),
        ),
        migrations.AlterUniqueTogether(
            name='participation',
            unique_together={('user', 'visit')},
        ),
    ]
