# Generated by Django 2.0.7 on 2018-09-11 17:38

from django.db import migrations, models
import django.db.models.deletion
import markdownx.models
import projects.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('dynamicforms', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Edition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField(default=projects.utils.this_year, help_text="L'année où se déroule cette édition.", verbose_name='année')),
                ('name', models.CharField(blank=True, default='', help_text='Un nom optionnel pour cette édition (exemple : "Berlin").', max_length=200, verbose_name='nom')),
                ('description', markdownx.models.MarkdownxField(blank=True, default='', help_text='Une description spécifique pour cette édition.')),
            ],
            options={
                'verbose_name': 'édition',
                'ordering': ('-year',),
                'get_latest_by': 'year',
            },
        ),
        migrations.CreateModel(
            name='EditionForm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deadline', models.DateField(help_text="Les lycéens ne pourront plus s'inscrire après cette date.", verbose_name='date butoir')),
            ],
            options={
                'verbose_name': 'formulaire projet',
                'verbose_name_plural': 'formulaires projet',
                'ordering': ('deadline',),
            },
        ),
        migrations.CreateModel(
            name='EditionOrganizer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.CharField(blank=True, default='', help_text='Exemple : responsable projet, responsable inscriptions…', max_length=100, verbose_name='rôle')),
            ],
            options={
                'verbose_name': 'organisateur',
            },
        ),
        migrations.CreateModel(
            name='Participation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('submitted', models.DateTimeField(auto_now_add=True, help_text='Date de soumission de la participation', verbose_name='soumis le')),
                ('state', models.CharField(choices=[('pending', 'En attente'), ('valid', 'Validé'), ('accepted', 'Accepté'), ('rejected', 'Refusé'), ('cancelled', 'Annulé')], default='pending', help_text="État de la participation. En attente = en cours de validation par les organisateurs. Validé = toutes les pièces ont été reçues et sont conformes. Accepté = le lycéen a été sélectionné pour participer. Refusé = le lycéen n'a pas été sélectionné pour participer. Annulé = le lycéen a annulé sa participation.", max_length=10, verbose_name='état')),
                ('edition', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='participations', to='projects.Edition', verbose_name='édition')),
                ('entry', models.OneToOneField(help_text="Réponses au formulaire d'inscription", null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='project_participation', to='dynamicforms.FormEntry', verbose_name='entrée')),
            ],
            options={
                'ordering': ('-submitted',),
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Le nom du projet.', max_length=200, verbose_name='nom')),
                ('description', markdownx.models.MarkdownxField(blank=True, default='', help_text='Une description générale du projet')),
                ('logo', models.ImageField(blank=True, help_text='Le logo du projet ou une image représentative.', null=True, upload_to='projects/logos/')),
            ],
            options={
                'verbose_name': 'projet',
                'ordering': ('name',),
            },
        ),
    ]
