# Generated by Django 2.0.7 on 2018-09-11 17:38

from django.db import migrations, models
import django.db.models.deletion
import dynamicforms.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Answer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('answer', models.TextField(blank=True, null=True, verbose_name='réponse')),
            ],
            options={
                'verbose_name': 'réponse',
            },
        ),
        migrations.CreateModel(
            name='File',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300, verbose_name='nom')),
                ('file', models.FileField(upload_to=dynamicforms.utils.file_upload_to, verbose_name='fichier')),
            ],
            options={
                'verbose_name': 'fichier',
                'verbose_name_plural': 'fichiers',
            },
        ),
        migrations.CreateModel(
            name='Form',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=300, verbose_name='titre')),
                ('slug', models.SlugField(blank=True, default='', max_length=100)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='créé le')),
            ],
            options={
                'verbose_name': 'formulaire',
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='FormEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('submitted', models.DateTimeField(auto_now_add=True, help_text="Date et heure de soumission de l'entrée.", verbose_name='soumis le')),
                ('form', models.ForeignKey(help_text="Formulaire associé à l'entrée.", on_delete=django.db.models.deletion.CASCADE, related_name='entries', to='dynamicforms.Form', verbose_name='formulaire')),
            ],
            options={
                'verbose_name': 'entrée de formulaire',
                'verbose_name_plural': 'entrées de formulaire',
                'ordering': ('-submitted',),
            },
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.CharField(help_text='intitulé de la question', max_length=300, verbose_name='intitulé')),
                ('type', models.CharField(choices=[('text-small', 'Texte court'), ('text-long', 'Texte long'), ('yes-no', 'Oui/Non'), ('date', 'Date'), ('sex', 'Sexe')], max_length=100, verbose_name='type de question')),
                ('help_text', models.CharField(blank=True, default='', help_text='Apporte des précisions sur la question', max_length=300, verbose_name='aide')),
                ('required', models.BooleanField(default=True, verbose_name='requis')),
                ('order', models.PositiveIntegerField(default=0, verbose_name='position')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='Section',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100, verbose_name='titre')),
                ('order', models.PositiveIntegerField(default=0, verbose_name='position')),
                ('form', models.ForeignKey(help_text='Formulaire associé à la section.', on_delete=django.db.models.deletion.CASCADE, related_name='sections', to='dynamicforms.Form', verbose_name='formulaire')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.AddField(
            model_name='question',
            name='section',
            field=models.ForeignKey(help_text='Section de formulaire associée à la question.', on_delete=django.db.models.deletion.CASCADE, related_name='questions', to='dynamicforms.Section', verbose_name='section'),
        ),
        migrations.AddField(
            model_name='file',
            name='form',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='files', to='dynamicforms.Form', verbose_name='formulaire'),
        ),
        migrations.AddField(
            model_name='answer',
            name='entry',
            field=models.ForeignKey(help_text='Entrée associée à la réponse.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='answers', to='dynamicforms.FormEntry', verbose_name='entrée'),
        ),
        migrations.AddField(
            model_name='answer',
            name='question',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='answers', to='dynamicforms.Question'),
        ),
    ]
