"""Users API views."""

import email
from django.contrib.auth import get_user_model
from dry_rest_permissions.generics import DRYPermissions
from rest_framework import viewsets
from .serializers import UserSerializer, CharterSerializer
from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework.decorators import action
from rest_framework import status


User = get_user_model()


class UserViewSet(viewsets.ReadOnlyModelViewSet):
    """API endpoint that allows users to be viewed.

    retrieve:
    Return a user instance.

    list:
    Return all users.
    """

    queryset = User.objects.all()
    serializer_class = UserSerializer
    permission_classes = (DRYPermissions,)


class UserCheckChartViewSet(APIView):
    """API endpoint that allows to see of user have signed charter.

        retrieve:
        Return a email .

        list:
        Return a boolean value.
    """

    def get(self, *args, **kwargs):
        user = User.objects.filter(
            email=self.request.query_params.get('email'))
        print(self.request.query_params.get('email'))
        try:
            if user[0].HasSignedCharter:
                resp = status.HTTP_200_OK
            else:
                resp = status.HTTP_401_UNAUTHORIZED
            return Response(status=resp)
        except IndexError:
            return Response(status=status.HTTP_404_NOT_FOUND)

    def post(self, *args, **kwargs):
        print(self.request.query_params.get('email'))
        user = User.objects.filter(
            email=self.request.query_params.get('email'))
        if len(user) != 0:
            resp = status.HTTP_200_OK
            user[0].HasSignedCharter = True
            user[0].save()
        else:
            resp = status.HTTP_404_NOT_FOUND
        return Response(status=resp)
