# Generated by Django 2.0.4 on 2018-06-06 21:11

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import markdownx.models
import projects.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Edition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, default='', help_text='Un nom optionnel pour cette édition (exemple : "Berlin").', max_length=200, verbose_name='nom')),
                ('year', models.IntegerField(default=projects.models.this_year, help_text="L'année où se déroule cette édition.", verbose_name='année')),
                ('description', markdownx.models.MarkdownxField(help_text='Une description spécifique pour cette édition.')),
            ],
            options={
                'verbose_name': 'édition',
                'ordering': ('-year',),
            },
        ),
        migrations.CreateModel(
            name='EditionOrganizer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('edition', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='projects.Edition', verbose_name='édition')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='utilisateur')),
            ],
            options={
                'verbose_name': 'organisateur',
            },
        ),
        migrations.CreateModel(
            name='Participation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('submitted', models.DateTimeField(auto_now_add=True, help_text='Date de soumission de la participation', verbose_name='soumis le')),
                ('status', models.CharField(choices=[('pending', 'En attente'), ('valid', 'Validé'), ('accepted', 'Accepté'), ('rejected', 'Refusé'), ('cancelled', 'Annulé')], help_text="L'état de la participation. En attente = en cours de validation par les organisateurs. Validé = toutes les pièces ont été reçues et sont conformes. Accepté = le lycéen a été sélectionné pour participer. Refusé = le lycéen n'a pas été sélectionné pour participer. Annulé = le lycéen a annulé sa participation.", max_length=10, verbose_name='statut')),
                ('edition', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='participations', to='projects.Edition', verbose_name='sortie')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='project_participations', to=settings.AUTH_USER_MODEL, verbose_name='utilisateur')),
            ],
            options={
                'ordering': ('-submitted',),
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Le nom du projet.', max_length=200, verbose_name='nom')),
                ('description', markdownx.models.MarkdownxField(help_text='Une description générale du projet')),
                ('logo', models.ImageField(blank=True, help_text='Le logo du projet ou une image représentative.', null=True, upload_to='projects/logos/')),
            ],
            options={
                'verbose_name': 'projet',
                'ordering': ('name',),
            },
        ),
        migrations.AddField(
            model_name='edition',
            name='organizers',
            field=models.ManyToManyField(through='projects.EditionOrganizer', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='edition',
            name='project',
            field=models.ForeignKey(help_text='Le projet dont ceci est une édition.', on_delete=django.db.models.deletion.CASCADE, related_name='editions', to='projects.Project', verbose_name='projet'),
        ),
    ]
