import React, { useEffect, useState } from "react";
import { Link } from "react-router-dom";

import "../styles/Home.css";

export default function HomePage({ restaurantsList, setSelection, loading }) {
  const [message, setMessage] = useState(() => () => "");

  useEffect(() => {
    let width = window.innerWidth > 0 ? window.innerWidth : screen.width;
    width = width > 600;
    if (width) {
      setMessage(() => (restaurant) => {
        if (restaurant.waiting_time) {
          return `Temps d'attente estimé à ${restaurant.waiting_time} minutes`;
        } else {
          return "Pas de données";
        }
      });
    } else {
      setMessage(() => (restaurant) => {
        if (restaurant.waiting_time) {
          return `${restaurant.waiting_time} min d'attente`;
        }
      });
    }
  }, [loading]);

  return (
    <div id="home-container">
      <h1 id="home-selection-title">Sélectionnez votre restaurant</h1>
      {loading ? (
        <span>Chargement...</span>
      ) : (
        <table id="home-table">
          <tbody>
            {restaurantsList.map((restaurant, index) => {
              return (
                <tr key={index}>
                  <td className="home-restaurant-name">
                    <span className="home-arrow-reverse">
                      <Link
                        to={encodeURIComponent(restaurant.name)}
                        onClick={() => setSelection(restaurant)}
                        className="home-link-item"
                      >
                        {restaurant.name}
                      </Link>
                      <span className="home-arrow">&#10132;</span>
                    </span>
                  </td>
                  <td className="home-restaurant-status">
                    Actuellement {restaurant.status ? "ouvert" : "fermé"}
                  </td>
                  {restaurant.status && (
                    <td className="home-waiting-time">{message(restaurant)}</td>
                  )}
                </tr>
              );
            })}
          </tbody>
        </table>
      )}
    </div>
  );
}
