import React, { useEffect, useState } from "react";
import axios from "axios";

import "../styles/NewsForm.css";

export default function NewsForm() {
  const [places, setPlaces] = useState([]);

  const fetchPlaces = () => {
    axios
      .get(`${process.env.REACT_APP_BASE_URL_BACK}/restaurants`)
      .then((res) => {
        setPlaces(res.data);
      })
      .catch((e) => {
        console.log(e);
      });
  };

  const Submit = (ev) => {
    ev.preventDefault();
    let { title, content, end_date, place } = ev.target.elements;

    axios
      .post(
        `${process.env.REACT_APP_BASE_URL_BACK}/news`,
        {
          title: title.value,
          content: content.value,
          end_date: end_date.value,
          place: place.value,
        },
        { withCredentials: true },
      )
      .then(() => {
        ev.target.reset();
        alert("L'actualité a bien été postée !");
      })
      .catch((e) => {
        console.log(e);
        alert("Une erreur est survenue");
      });
  };

  useEffect(fetchPlaces, []);

  return (
    <form onSubmit={Submit} id="news-form-container">
      <label htmlFor="title">Titre</label>
      <input name="title" />
      <label htmlFor="content" className="news-form-label">
        Contenu
      </label>
      <textarea name="content" style={{ resize: "none" }} />
      <label htmlFor="end_date" className="news-form-label">
        Date de fin
      </label>
      <input type="datetime-local" name="end_date" style={{ minHeight: "2rem" }} />
      <label htmlFor="place" className="news-form-label">
        Restaurant concerné
      </label>
      <select name="place">
        {places.map((place) => (
          <option key={place.name}>{place.name}</option>
        ))}
      </select>
      <input id="submit_event" type="submit" className="news-form-label" />
    </form>
  );
}
