from fastapi import APIRouter, Depends
from sqlalchemy.orm import Session
from typing import List

from db import schemas, crud
from db.database import get_db


router = APIRouter(prefix="/api")


@router.get('/{place}/waiting_time', response_model=schemas.WaitingTime, tags=["stats"])
async def waiting_time(place: str, db: Session = Depends(get_db)):
    return crud.get_waiting_time(place, db)


@router.get('/{place}/stats/avg_graph', response_model=list, tags=["stats"])
async def stats(place: str, db: Session = Depends(get_db)):
    return crud.get_avg_graph(place, db)


@router.get('/{place}/stats/current_graph', response_model=schemas.Graph, tags=["stats"])
async def stats(place: str, db: Session = Depends(get_db)):
    return crud.get_current_graph(place, db)


@router.get('/{place}/opening_hours',
            response_model=List[schemas.OpeningHours], tags=["timetable"])
async def get_opening_hours(place: str, db: Session = Depends(get_db)):
    return crud.get_opening_hours(place, db)


@router.post('/opening_hours', response_model=schemas.OpeningHours, tags=["timetable"])
async def create_opening_hours(opening_hours: schemas.OpeningHoursBase, db: Session = Depends(get_db)):
    return crud.create_opening_hours(opening_hours, db)


@router.delete('/opening_hours/{id}', response_model=None, tags=["timetable"])
async def delete_opening_hours(id: int, db: Session = Depends(get_db)):
    return crud.delete_opening_hours(id, db)


@router.get('/restaurants', response_model=List[schemas.Restaurant], tags=["timetable"])
async def get_restaurants(db: Session = Depends(get_db)):
    return crud.get_restaurants(db)
