from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware
from dotenv import load_dotenv
from threading import Thread
import os

from db import database, models
from routers import *
from video_capture import handle_cameras

app = FastAPI(docs_url="/api/docs", openapi_url="/api/openapi.json")

# load environment variables
load_dotenv()

origins = [
    os.getenv('WEB_ROOT'),
]

app.add_middleware(
    CORSMiddleware,
    allow_origins=origins,
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"]
)


@app.on_event("startup")
async def on_startup():
    # Database creation
    models.Base.metadata.create_all(bind=database.engine)
    t = Thread(target=handle_cameras)
    t.start()


# Integration of routers
app.include_router(stats.router)
app.include_router(comments.router)
app.include_router(news.router)
app.include_router(authentication.router)
app.include_router(websocket.router)
app.include_router(records.router)
