import React, { useEffect, useState } from "react";
import axios from "axios";

import "../styles/WaitingTime.css";

export default function WaitingTime({ place, lastMessage }) {
  const [data, setData] = useState({ status: true, waiting_time: null, next_timetable: null });
  const [reload, setReload] = useState(true);

  useEffect(() => {
    if (reload) {
      axios
        .get(`${process.env.REACT_APP_BASE_URL_BACK}/${encodeURIComponent(place)}/waiting_time`)
        .then((res) => {
          setData(res.data);
        });
      setReload(false);
    }
  }, [reload]);

  useEffect(() => {
    if (lastMessage?.data) {
      let new_message = JSON.parse(lastMessage.data);
      if (new_message.type == "data") {
        setReload(true);
      }
    }
  }, [lastMessage]);

  return (
    <div id="waiting-time-parent">
      {data.status ? (
        data.waiting_time || data.waiting_time == 0 ? (
          <div id="waiting-time-display">
            Le temps d&apos;attente est estimé à
            <div className="waiting-time-minutes">
              <b id="waiting-time-number">{data.waiting_time}</b> minutes
            </div>
          </div>
        ) : (
          <div className="waiting-time-minutes">Pas de données</div>
        )
      ) : data.next_timetable ? (
        <div id="waiting-time-display">
          Le RU ouvre aujourd&apos;hui à
          <span className="waiting-time-minutes">
            <b id="waiting-time-number">{data.next_timetable}</b>
          </span>
        </div>
      ) : (
        <div className="waiting-time-minutes">Le RU est fermé pour aujourd&apos;hui.</div>
      )}
    </div>
  );
}
