from fastapi import APIRouter, Depends
from sqlalchemy.orm import Session

from db import schemas, crud
from db.database import get_db


router = APIRouter(prefix="/api", tags=["stats"])


@router.get('/{place}/waiting_time', response_model=schemas.WaitingTime)
async def waiting_time(place: str, db: Session = Depends(get_db)):
    return crud.get_waiting_time(place, db)


@router.get('/{place}/stats/avg_graph', response_model=list)
async def stats(place: str, db: Session = Depends(get_db)):
    return crud.get_avg_graph(place, db)


@router.get('/{place}/stats/current_graph', response_model=schemas.Graph)
async def stats(place: str, db: Session = Depends(get_db)):
    return crud.get_current_graph(place, db)
