from fastapi import APIRouter, Depends
from sqlalchemy.orm import Session

from db import schemas, crud
from db.database import get_db


router = APIRouter(prefix="/api", tags=["stats"])


@router.get('/{place}/waiting_time', response_model=tuple)
async def waiting_time(place: str, db: Session = Depends(get_db)):
    return crud.get_waiting_time(place, db)


@router.get('/{place}/stats/avg_graph', response_model=list)
async def stats(place: str, db: Session = Depends(get_db)):
    return crud.get_avg_graph(place, db)


@router.get('/{place}/stats/current_graph', response_model=list)
async def stats(place: str, db: Session = Depends(get_db)):
    return crud.get_current_graph(place, db)

@router.get('/{place}/opening_hours', response_model=List[schemas.OpeningHours])
async def get_opening_hours(place: str, page: int = 1, db: Session = Depends(get_db)):
    return crud.get_opening_hours(place, page, db)


@router.get('/{place}/opening_hours/{day}/{timeslot}', response_model=List[schemas.OpeningHours])
async def get_timeslot(place: str, day: int, timeslot: bool, db: Session = Depends(get_db)):
    return crud.get_timeslot(place, day, timeslot, db)


@router.post('/opening_hours', response_model=schemas.OpeningHours)
async def create_opening_hours(opening_hours: schemas.OpeningHoursBase, db: Session = Depends(get_db)):
    return crud.create_opening_hours(opening_hours, db)


@router.delete('/opening_hours/{id}', response_model=None)
async def delete_opening_hours(id: int, db: Session = Depends(get_db)):
    return crud.delete_opening_hours(id, db)
