from fastapi import APIRouter, Body, Depends
from sqlalchemy.orm import Session
from typing import List

from db import schemas, crud
from db.database import get_db


router = APIRouter(prefix="/api", tags=["comments"])


@router.get('/{place}/comments', response_model=List[schemas.Comment])
async def get_comments(place: str, page: int = 1, db: Session = Depends(get_db)):
    return crud.get_comments(place, page, db)


@router.post('/{place}/comments', response_model=schemas.Comment)
async def create_comment(place: str, comment: schemas.CommentBase = Body(...), db: Session = Depends(get_db)):
    return crud.create_comment(place, comment, db)


@router.delete('/comments/{id}', response_model=None)
async def delete_comment(id: int, db: Session = Depends(get_db)):
    return crud.delete_comment(id, db)
