import React, { useEffect, useState } from "react";
import axios from "axios";

import { NewsForm, ClosureForm, Comments } from "../components";

import "../styles/Admin.css";

export default function AdminPage({ lastMessage }) {
  const [form, setForm] = useState("");

  function NewsList() {
    const [place, setPlace] = useState(null);
    const [places, setPlaces] = useState([]);

    const fetchPlaces = () => {
      axios
        .get(`${process.env.REACT_APP_BASE_URL_BACK}/restaurants`)
        .then((res) => {
          setPlaces(res.data);
          res.data.length && setPlace(res.data[0].name);
        })
        .catch((e) => {
          console.log(e);
        });
    };

    useEffect(fetchPlaces, []);

    return (
      <div id="admin-news-list">
        <select id="admin-select-place" name="place" onChange={(ev) => setPlace(ev.target.value)}>
          {places.map((place) => (
            <option key={place.name}>{place.name}</option>
          ))}
        </select>
        <Comments place={place} lastMessage={lastMessage} infos admin />
      </div>
    );
  }

  let forms = {
    news: <NewsForm />,
    newsList: <NewsList />,
    closure: <ClosureForm />,
  };

  return (
    <div id="admin-container">
      <select defaultValue="" onChange={(ev) => setForm(ev.target.value)}>
        <option className="admin-select-option" value="">
          -- Sélectionner une action --
        </option>
        <option className="admin-select-option" value="news">
          Ajouter une actualité
        </option>
        <option className="admin-select-option" value="newsList">
          Supprimer une actualité
        </option>
        <option className="admin-select-option" value="closure">
          Renseigner une fermeture exceptionnelle
        </option>
      </select>
      {form && forms[form]}
    </div>
  );
}
