import React, { useContext, useEffect } from "react";
import { Link } from "react-router-dom";
import { BiLogOutCircle, BiLogInCircle } from "react-icons/bi";

import "../styles/Header.css";
import { User } from "../index";
import axios from "axios";

export default function Header({ selection, setSelection }) {
  const [user, setUser] = useContext(User);
  const connected = new URLSearchParams(location.search).get("connected");

  let width = window.innerWidth > 0 ? window.innerWidth : screen.width;
  width = width > 600;

  useEffect(() => {
    if (connected) {
      axios
        .get(`${process.env.REACT_APP_BASE_URL_BACK}/auth`, { withCredentials: true })
        .then((res) => {
          setUser(res.data);
          localStorage.setItem("user", JSON.stringify(res.data));
        })
        .catch((e) => console.log(e));
    }
  }, [connected]);

  return (
    <div id="header-container" style={!selection ? { flexDirection: "row" } : {}}>
      <div id="header-restaurant-status">
        {width &&
          (!selection
            ? "Accueil"
            : `${selection.name} : actuellement ${selection.status ? "ouvert" : "fermé"}`)}
      </div>
      <Link id="header-home-link" to="/" onClick={() => setSelection(null)}>
        <h2>{width || !selection ? "Eatfast" : selection.name}</h2>
      </Link>
      <div id="header-timetable">
        {selection ? (
          width ? (
            selection.timetable && `Horaires : ${selection.timetable}`
          ) : (
            selection.timetable
          )
        ) : user ? (
          <BiLogOutCircle
            id="header-button"
            title="Déconnexion"
            onClick={() => {
              localStorage.removeItem("user");
              window.location.assign(`${process.env.REACT_APP_BASE_URL_BACK}/auth/logout`);
            }}
          />
        ) : (
          <BiLogInCircle
            id="header-button"
            title="Connexion"
            onClick={() => {
              window.location.assign(`${process.env.REACT_APP_BASE_URL_BACK}/auth/login`);
            }}
          />
        )}
      </div>
    </div>
  );
}
