import React, { useEffect, useState } from "react";
import axios from "axios";

export default function ClosureForm() {
  const [places, setPlaces] = useState([]);

  const fetchPlaces = () => {
    axios
      .get(`${process.env.REACT_APP_BASE_URL_BACK}/restaurants`)
      .then((res) => {
        setPlaces(res.data);
      })
      .catch((e) => {
        console.log(e);
      });
  };

  const Submit = (ev) => {
    ev.preventDefault();
    let { place, beginning_date, end_date } = ev.target.elements;

    axios
      .post(`${process.env.REACT_APP_BASE_URL_BACK}/closure`, {
        place: place.value,
        beginning_date: beginning_date.value,
        end_date: end_date.value,
      })
      .then((res) => {
        console.log(res);
      })
      .catch((e) => {
        console.log(e);
      });
  };

  useEffect(fetchPlaces, []);

  return (
    <form onSubmit={Submit} id="news-form-container">
      <label htmlFor="place">Restaurant concerné</label>
      <select name="place">
        {places.map((place) => (
          <option key={place.name}>{place.name}</option>
        ))}
      </select>
      <label htmlFor="beginning_date" className="news-form-label">
        Date de fermeture
      </label>
      <input type="datetime-local" name="beginning_date" style={{ minHeight: "2rem" }} />
      <label htmlFor="end_date" className="news-form-label">
        Date de réouverture
      </label>
      <input type="datetime-local" name="end_date" style={{ minHeight: "2rem" }} />
      <input id="submit_event" type="submit" className="news-form-label" />
    </form>
  );
}
