"""
Models of the database for magasin app
"""
from sqlalchemy import Column, ForeignKey, Integer, DateTime, Float, Interval, String, Text, Time
from sqlalchemy.orm import relationship

from db.database import Base


class CollaborativeRecords(Base):
    """CollaborativeRecords sql table model"""
    __tablename__ = "collection"

    id = Column(Integer, primary_key=True, index=True)
    user_id = Column(Integer, ForeignKey("users.id", ondelete='SET NULL'))
    place = Column(String(30))
    date = Column(DateTime)
    waiting_time = Column(Interval)


class Records(Base):
    """Records sql table model"""
    __tablename__ = "records"

    id = Column(Integer, primary_key=True, index=True)
    place = Column(String(30))
    date = Column(DateTime)
    density = Column(Float)
    waiting_time = Column(Interval)


class Comments(Base):
    """Comments sql table model"""
    __tablename__ = "comments"

    id = Column(Integer, primary_key=True, index=True)
    user_id = Column(Integer, ForeignKey("users.id"))
    content = Column(Text)
    published_at = Column(DateTime)
    place = Column(String(30))


class News(Base):
    """News sql table model"""
    __tablename__ = "news"

    id = Column(Integer, primary_key=True, index=True)
    title = Column(String(50))
    content = Column(Text)
    published_at = Column(DateTime)
    end_date = Column(DateTime)
    place = Column(String(30))


class OpeningHours(Base):
    """OpeningHours sql table model"""
    __tablename__ = "opening_hours"

    id = Column(Integer, primary_key=True, index=True)
    place = Column(String(30))
    day = Column(Integer)
    open_time = Column(Time)
    close_time = Column(Time)


class Closure(Base):
    """ Register exceptional closure for a period sql table model """
    __tablename__ = "closure"

    id = Column(Integer, primary_key=True, index=True)
    place = Column(String(30))
    beginning_date = Column(DateTime)
    end_date = Column(DateTime)


class Users(Base):
    """ User sql table model """
    __tablename__ = "users"

    id = Column(Integer, primary_key=True, index=True)
    state = Column(String(50))
    username = Column(String(50))
    cookie = Column(String(50))
    expiration_date = Column(DateTime)
    comments = relationship("Comments")
    comments = relationship("CollaborativeRecords")
