const express = require('express');
const userModel = require('../models/user.model');
const router = express.Router();

router.get('/:id', function(req, res) {
	let id = parseInt(req.params.id);
	userModel.getUser(id).then(out => res.json(out));
});

router.post('/', function(req, res) {
	userModel.addUser(req.body.uName, req.body.fName, req.body.lName, req.body.phoneNumber).then(out => res.json(out.dataValues))
	.catch(err => res.json(err));
});

router.delete('/:id', function(req, res) {
	let id = parseInt(req.params.id);
	userModel.deleteUser(id).then(out => res.json(out.dataValues))
	.catch(() => res.json({error: 'User does not exist'}));
});

module.exports = router;
