const express = require('express');
const itemModel = require('../models/item.model');
const authMiddleware = require('../middlewares/authMiddleware');
const router = express.Router();

const DEFAULT_PAGE = 0;
const DEFAULT_STEP = 10;

router.use(authMiddleware.checkAuth());

router.get('/byId/:id', function(req, res) {
	let id = parseInt(req.params.id);
	itemModel.getItem(id).then(out => res.json(out));
});

router.get('/date', function(req, res) {
	let page = parseInt(req.query.page);
	let step = parseInt(req.query.step);
	let typeItem = parseInt(req.query.typeItem);
	if(isNaN(page))
		page = DEFAULT_PAGE;
	if(isNaN(step))
		step = DEFAULT_STEP;
	itemModel.getItemsByDate(page, step, typeItem).then(out => res.json(out));
});

router.get('/userId', function(req, res) {
	let userId = parseInt(req.query.uId);
	let page = parseInt(req.query.page);
	let step = parseInt(req.query.step);
	let typeItem = parseInt(req.query.typeItem);
	if(isNaN(page))
		page = DEFAULT_PAGE;
	if(isNaN(step))
		step = DEFAULT_STEP;
	itemModel.getItemsByUserId(userId, page, step, typeItem).then(out => res.json(out));
});

router.get('/description', function(req, res) {
	let page = parseInt(req.query.page);
	let step = parseInt(req.query.step);
	let typeItem = parseInt(req.query.typeItem);
	if(isNaN(page))
		page = DEFAULT_PAGE;
	if(isNaN(step))
		step = DEFAULT_STEP;
	itemModel.getItemsByDescription(req.query.desc, page, step, typeItem).then(out => res.json(out));
});

router.post('/', function(req, res) {
	itemModel.addItem(req.body.description, req.body.price, req.body.userId, req.body.typeItem).then(out => res.json(out.dataValues))
	.catch(err => res.json(err));
});

router.delete('/:id', function(req, res) {
	let id = parseInt(req.params.id);
	itemModel.deleteItem(id).then(out => res.json(out.dataValues))
	.catch(() => res.json({error: 'User does not exist'}));
});

module.exports = router;
