const express = require('express');
const moment = require('moment');

const myPassport = require('../config/my-passport');

const userModel = require('../models/user.model');

const router = express.Router();

router.get('/', function(req,res){
	let result = 'You\'re not connected : <a href="/auth/connect">Login</a>'
	if(req.session.connected){
		result = 'You\'re connected : <a href="/auth/disconnect">Logout</a>'
	}
	res.status(200).send(result);
});

router.get('/failed', function(req,res){
	res.status(200).send('Failed : <a href="/auth">Try again</a>');
});

router.get('/success', function(req,res){
	res.status(200).send(JSON.stringify(req.session.user));
});

router.get('/connect',
  myPassport.authenticate('oauth2'));

router.get('/disconnect', function(req,res){
	req.session.connected = false;
	res.redirect('/auth');
});

router.get('/connect/callback',
  myPassport.authenticate('oauth2', { failureRedirect: '/auth/failed' }),
  function(req, res) {
    // Successful authentication, auth user & redirect home.
	let user = res.req.user
	req.session.user = null
	let userInfos = {
		uName : user.login,
		fName : user.first_name,
		lName : user.last_name,
		phoneNumber : user.mobile_number,
		token : req.query.code,
		expires : moment().add(1,'days')
	}
	userModel.authUser(userInfos)
	.then(()=>{
		userModel.getUserUName(userInfos.uName)
		.then((loggedUser)=>{
			userModel.refreshUser(loggedUser);
			req.session.user = loggedUser.toJSON();
			res.redirect('/auth/success');
		})
	})
	.catch((err) => {
		console.log(err);
		res.redirect('/auth/failed');
	})
  }
);

module.exports = router;