var Sequelize = require('sequelize');
var sequelize = require('./sequelize');
const moment = require('moment')

sequelize
  .authenticate()
  .then(() => {
    console.log('Connection has been established successfully.');
  })
  .catch(err => {
    console.error('Unable to connect to the database:', err);
  });

var Users = sequelize.define('Users', {
	uName: {
		type : Sequelize.STRING,
		allowNull: false,
		unique: true,
	},
	fName: Sequelize.STRING,
	lName: Sequelize.STRING,
	phoneNumber: Sequelize.STRING,
	token: Sequelize.STRING,
	expires: Sequelize.DATE
},{
	timestamps: false,
	tableUser: 'Users',
});

sequelize.sync({force:true})

function refreshUser(user){
	expiresTime = user.toJSON().expires
	if( moment.duration(moment(expiresTime).diff(moment())).asHours() < 23){
		user.updateAttributes({
			expires : moment().add(1,'days')
		})
	}
}
function refreshById(id,timeLeft){
	if( moment.duration(moment(user.expires).diff(moment())).asHours() < 23){
		return true;
	}else{
		return false;
	}
}

function getUser(id) {
	return Users.findById(id);
}

function getUserUName(uName) {
	return Users.findOne(
		{ where: { uName: uName } }
	);
}

function authUser(userInfos) {
	return Users.upsert(
		userInfos
	).then(function(users) {
		return users;
	}).catch((err) => {
		console.log(err)
	})
}

function getUserByToken(token){
	return Users.findOne({where : {token : token}});
}

function addUser(uName, fName, lName, phoneNumber, token, expires) {
	return Users.create({ uName: uName, fName: fName, lName: lName, phoneNumber: phoneNumber, token : token, expires : expires });
}

function deleteUser(id) {
	return Users.findOne(
		{ where: { id: id } }
	)
		.then(function(users) {
			return users.destroy();
		}).catch((err) => {
		console.log(err)
	})
}

module.exports = {getUser, addUser, deleteUser, authUser, refreshUser,getUserUName,getUserByToken}
