var Sequelize = require('sequelize');
var sequelize = require('./sequelize');

sequelize
  .authenticate()
  .then(() => {
    console.log('Connection has been established successfully.');
  })
  .catch(err => {
    console.error('Unable to connect to the database:', err);
  });

var Items = sequelize.define('Items', {
	description: Sequelize.STRING,
	price: Sequelize.FLOAT,
    typeItem: Sequelize.INTEGER, // typeDemande
    userId: Sequelize.INTEGER
}, {
	tableItem: 'Items',
});

sequelize.sync({force:true}).then(() => {
  Items.create({
    description: 'Slip semi-propre',
    price: 4,
    userId: 1,
    typeItem: 2
  })

  Items.create({
    description: 'Bon shit sa mère',
    price: 10,
    userId: 2,
    typeItem: 1
  })
})

function getItem(id) {
  return Items.findById(id);
}

function getItemsByDate(page, step, typeItem) {
  var offset = (page * step);
  let where = {}
  if(!isNaN(typeItem)){
      where = {typeItem : typeItem}
  }
  console.log(where)
  return Items.findAll({
    offset: offset,
    limit: offset + step,
    order: [['createdAt', 'DESC']],
    where: where
  });
}

function getItemsByUserId(id, page, step, typeItem){
  var offset = (page * step);
  let where = {userId: id}
  if(!isNaN(typeItem)){
      where = {
          typeItem : typeItem,
          userId: id
      }
  }
  return Items.findAll({
    offset: offset,
    limit: offset + step,
    where: where
  });
}

function getItemsByDescription(description, page, step, typeItem) {
  var offset = (page * step);
  let where = { description: { $like: `%${description}%` } }
  if(!isNaN(typeItem)){
      where = {
          description: { $like: `%${description}%` },
          typeItem : typeItem
      }
  }
  console.log(where)
  return Items.findAll({
    offset: offset,
    limit: offset + step,
    where: where
  });
}

function addItem(description, price, userId, typeItem) {
  return Items.create({ description: description, price: price, userId: userId, typeItem : typeItem});
}

function deleteItem(id) {
  return Items.findOne(
    { where: { id: id } }
  )
    .then(function(items) {
      return items.destroy();
    })
}

module.exports = {
    getItem,
    getItemsByDate,
    getItemsByUserId,
    getItemsByDescription,
    addItem,
    deleteItem,
    typeItem : {demande : 1,offre : 2}
}
