<?php

namespace BackendBundle\Form;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class addPredictionType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('firstTeam', TextType::class, array(
                    'label' => 'Équipe 1',
            ))
            ->add('secondTeam', TextType::class, array(
                'label' => 'Équipe 2',
            ))
            ->add('league', EntityType::class, array(
                'label' => 'Ligue',
                'class' => 'BackendBundle\Entity\League',
                'choice_label' => 'name'
            ))
            ->add('date', DateTimeType::class, array(
                'label' => 'Date',
                'attr' => array('class' => 'datepicker')
            ))
            ->add('predictionWinFirst', NumberType::class, array(
                'label' => 'Côte victoire de l\'équipe 1',
            ))
            ->add('predictionWinSecond', NumberType::class, array(
                'label' => 'Côte victoire de l\'équipe 2',
            ))
            ->add('predictionDraw', NumberType::class, array(
                'label' => 'Côte match nul',
                'required' => false
            ));
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'BackendBundle\Entity\Prediction',
            'csrf_protection' => false,
        ));
    }

    public function getName()
    {
        return 'backend_bundleadd_prediction_type';
    }
}
