<?php

namespace BackendBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Prediction
 *
 * @ORM\Table(name="prediction")
 * @ORM\Entity(repositoryClass="BackendBundle\Repository\PredictionRepository")
 */
class Prediction
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="firstTeam", type="string", length=255)
     */
    private $firstTeam;

    /**
     * @var string
     *
     * @ORM\Column(name="secondTeam", type="string", length=255)
     */
    private $secondTeam;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date", type="datetime")
     */
    private $date;

    /**
     * @var string
     *
     * @ORM\Column(name="score", type="string", length=255, nullable=true)
     */
    private $score;

    /**
     * @var float
     *
     * @ORM\Column(name="predictionWinFirst", type="float")
     */
    private $predictionWinFirst;

    /**
     * @var float
     *
     * @ORM\Column(name="predictionWinSecond", type="float")
     */
    private $predictionWinSecond;

    /**
     * @var float
     *
     * @ORM\Column(name="predictionDraw", type="float", nullable = true)
     */
    private $predictionDraw;

    /**
     * @var League
     *
     * @ORM\ManyToOne(targetEntity="BackendBundle\Entity\League")
     * @ORM\JoinColumn(nullable=false)
     */
    private $league;

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set firstTeam
     *
     * @param string $firstTeam
     *
     * @return Prediction
     */
    public function setFirstTeam($firstTeam)
    {
        $this->firstTeam = $firstTeam;

        return $this;
    }

    /**
     * Get firstTeam
     *
     * @return string
     */
    public function getFirstTeam()
    {
        return $this->firstTeam;
    }

    /**
     * Set secondTeam
     *
     * @param string $secondTeam
     *
     * @return Prediction
     */
    public function setSecondTeam($secondTeam)
    {
        $this->secondTeam = $secondTeam;

        return $this;
    }

    /**
     * Get secondTeam
     *
     * @return string
     */
    public function getSecondTeam()
    {
        return $this->secondTeam;
    }

    /**
     * Set date
     *
     * @param \DateTime $date
     *
     * @return Prediction
     */
    public function setDate($date)
    {
        $this->date = $date;

        return $this;
    }

    /**
     * Get date
     *
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * Set score
     *
     * @param string $score
     *
     * @return Prediction
     */
    public function setScore($score)
    {
        $this->score = $score;

        return $this;
    }

    /**
     * Get score
     *
     * @return string
     */
    public function getScore()
    {
        return $this->score;
    }

    /**
     * Set predictionWinFirst
     *
     * @param float $predictionWinFirst
     *
     * @return Prediction
     */
    public function setPredictionWinFirst($predictionWinFirst)
    {
        $this->predictionWinFirst = $predictionWinFirst;

        return $this;
    }

    /**
     * Get predictionWinFirst
     *
     * @return float
     */
    public function getPredictionWinFirst()
    {
        return $this->predictionWinFirst;
    }

    /**
     * Set predictionWinSecond
     *
     * @param float $predictionWinSecond
     *
     * @return Prediction
     */
    public function setPredictionWinSecond($predictionWinSecond)
    {
        $this->predictionWinSecond = $predictionWinSecond;

        return $this;
    }

    /**
     * Get predictionWinSecond
     *
     * @return float
     */
    public function getPredictionWinSecond()
    {
        return $this->predictionWinSecond;
    }

    /**
     * Set predictionDraw
     *
     * @param float $predictionDraw
     *
     * @return Prediction
     */
    public function setPredictionDraw($predictionDraw)
    {
        $this->predictionDraw = $predictionDraw;

        return $this;
    }

    /**
     * Get predictionDraw
     *
     * @return float
     */
    public function getPredictionDraw()
    {
        return $this->predictionDraw;
    }

    /**
     * @return mixed
     */
    public function getLeague()
    {
        return $this->league;
    }

    /**
     * @param mixed $league
     */
    public function setLeague($league)
    {
        $this->league = $league;
    }
}

