/**
 * Created by jeremyguiselin on 01/12/2017.
 */

 (function (angular) {
   "use strict";

   /**
    * @ngdoc controller
    * @name TennisDetailsController
    *
    * @description
    * Controller for all the predictions of a tennis league.
    *
    * @ngInject
    */
   function TennisDetailsController(
     $ionicHistory,
     $scope,
     $http,
     $ionicLoading,
     constantConfig
   ) {

     /**
     Scope variables
     **/

     $scope.locale = window.navigator.language.split('-')[0];
     $scope.pictureUrl = constantConfig.imgUrl;

     /**
     End Scope variables
     **/

     /**
     Static variables
     **/

     var self = this;
     var deregistrationCallbackList = [];

     /**
     End Static variables
     **/

     /**
     Scope functions
     **/

     $scope.isUndefined = function (value) {
       return typeof value === 'undefined' || value === null;
     };

     $scope.myGoBack = function() {
       $ionicHistory.goBack();
     };


     $scope.getPredictionClass = function (prediction, value) {
       var percentages = [
         prediction.prediction_win_first,
         prediction.prediction_win_second
       ];
       percentages.sort();
       if (percentages.indexOf(value) === 1) {
         return "main-prediction";
       }

       return '';
     }

     $scope.getTick = function (prediction) {
       var percentages = [
         prediction.prediction_win_first,
         prediction.prediction_win_second
       ];

       var ticks = [
         'red-cross',
         'green-tick'
       ];

       percentages.sort();
       var predictionWin = null;
       if (prediction.winner) {
         predictionWin = prediction.prediction_win_second;
         if (prediction.first_team.id === prediction.winner) {
           predictionWin = prediction.prediction_win_first;
         }
         return ticks[percentages.indexOf(predictionWin)];
       }

       return null;
     }

     $scope.parseDate = function (date) {
       var locale = window.navigator.language.split('-')[0];
       date = date.split(' ')[0].split('-');

       if (locale === "fr") {
         return date[2] + '/' + date[1] + '/' + date[0].substr(-2);
       } else {
         return date[1] + '/' + date[2] + '/' + date[0].substr(-2);
       }
     }

     /**
     End Scope functions
     **/

     /**
     Controller functions
     **/

     this.parseScore = function (prediction) {
       if (prediction.score) {
         var score = prediction.score;
         var sets = score.split(' ');
         var scores = [];
         sets.forEach(function (set) {
           scores.push(set.split('-'));
         });
         prediction.score = scores;
       }
     };

     /**
     End Controller functions
     **/

     /**
     Scope events
     **/

     $scope.$on('$destroy', function(){
       angular.forEach(deregistrationCallbackList, function(deregistrationCallback){
         deregistrationCallback();
       });
       deregistrationCallbackList = null;
     });


     $scope.$on("$ionicView.beforeEnter", function(event, data){
       var leagueId = data.stateParams.leagueId;

       $ionicLoading.show({
         template: '<ion-spinner icon="ripple" class="spinner-assertive"></ion-spinner>',
         animation: 'fade-in',
         showBackdrop: true,
       });

       $http.get(constantConfig.apiUrl + 'predictions/league/' + leagueId).then(function (data) {
         var predictions = [];
         data['data'].forEach(function (prediction) {
           self.parseScore(prediction);
           predictions.push(prediction);
         });
         $scope.predictions = predictions;
         $scope.league = data['data'][0]['league'];
       }).finally(function () {
         $ionicLoading.hide();
       });
     });

     /**
     End Scope event
     **/


   }

   angular.module('starter')
     .controller('TennisDetailsController', TennisDetailsController);
 })(angular);
