(function (angular) {
    "use strict";
    /**
     * @ngdoc service
     * @name starter.PurchaseService
     *
     * @description
     *
     * A service for purchasing products
     *
     * @ngInject
     */
    function PurchaseService($http, $state, ToastService, constantConfig) {
        return {

          buyContent : function (uuid, purchaseId, leagues) {
            var self = this;
            var transactionData = {};
            if (window.cordova) {
              inAppPurchase
                .buy(purchaseId)
                .then(function (data) {
                  transactionData = {
                    transactionId: data.transactionId,
                    uuid: uuid,
                    leagues: leagues
                  };
                  self.savePurchase(transactionData);
                })
                .catch(function (err) {
                  ToastService.show('purchase_payment_error', 'long', 'center');
                });
            } else {
              transactionData = {
                transactionId: Math.random().toString(36).substring(7),
                uuid: uuid,
                leagues: leagues
              };
              self.savePurchase(transactionData);
            }

          },

          savePurchase: function (transactionData) {
            $http.post(constantConfig.apiUrl + 'save-purchase', transactionData)
              .then(function successCallback() {
                $state.reload();
                ToastService.show('purchase_ok', 'long', 'center');
              }, function errorCallback() {
                ToastService.show('purchase_internal_error', 'long', 'center');
              });
          }
        };

      }

    angular.module('starter')
        .service('PurchaseService', PurchaseService)
    ;
})(angular);
