(function (angular) {
    "use strict";
    /**
     * @ngdoc service
     * @name starter.NotificationService
     *
     * @description
     *
     * A service for receive notifications and register device.
     *
     * @ngInject
     */
    function NotificationService($http, constantConfig) {
        var service = {

          registerDevice: function () {

            var locale = window.navigator.language.split('-')[0];
            if (locale !== 'fr') {
              locale = 'en';
            }

            ionic.Platform.ready(function () {
              var deviceData = {};
              if (window.cordova) {
                var device = ionic.Platform.device();
                deviceData = device;
                var tokenAlreadyCreated = false;
                if (ionic.Platform.isIOS()) {
                  window.FirebasePlugin.grantPermission();
                }
                window.FirebasePlugin.getToken(function (token) {
                  deviceData = Object.assign(device, {'locale': locale, 'token': token});
                  tokenAlreadyCreated = true;
                }, function (error) {
                });

                if (!tokenAlreadyCreated) {
                  window.FirebasePlugin.onTokenRefresh(function (token) {
                    deviceData = Object.assign(device, {'locale': locale, 'token': token});
                  }, function (error) {
                  });
                }

              } else {
                //Mock deviceData
                deviceData = {
                  platform: 'Android',
                  version: '6.0.1',
                  model: 'AquarisE5',
                  uuid: '7f4a6a40e5c87157',
                  locale: locale,
                  token: 'cNgyx3ZgOX4:APA91bF5eigDuJLjj8wI8SC4l5KIHATuxi-2G5whpWI1n1jWpWWwRAwbEXec4fQ2S7HW8EdUPaREXJ5fVd_TZV8rZq_eIJIEhEadeH9wpsbYmUUM7E8H8Y0Qst9KmBuHWodCFFJPJ0vh'
                }
              }
              $http.post(constantConfig.apiUrl + 'devices/register', deviceData)
                .then(function successCallback() {
                }, function errorCallback() {
              });
            });
          }
        };

        return service;

      }

    angular.module('starter')
        .service('NotificationService', NotificationService)
    ;
})(angular);
