/**
 * Created by jeremyguiselin on 25/09/2016.
 */

(function (angular) {
  "use strict";

  /**
   * @ngdoc controller
   * @name NotificationController
   *
   * @description
   * Controller for the notification page.
   *
   * @ngInject
   */
  function NotificationController(
    constantConfig,
    $ionicHistory,
    $scope,
    $ionicLoading,
    $http
  ) {

    /**
    Scope variables
    **/

    $scope.locale = window.navigator.language.split('-')[0];

    /**
    End Scope variables
    **/

    /**
    Controller variables
    **/

    this.status = [];

    /**
    End Controller variables
    **/

    /**
    Static variables
    **/

    var self = this;
    var deregistrationCallbackList = [];
    var uuid = window.cordova ? ionic.Platform.device().uuid : '7f4a6a40e5c87157';

    /**
    End Static variables
    **/

    /**
    Controller functions
    **/

    this.findNotificationStatus = function(id) {
      var notificationStatus = 'read';
      self.status.forEach(function (el) {
        if (el.notification.id === id) {
          notificationStatus = el.status;
        }
      });
      return notificationStatus;
    };

    /**
    End Controller functions
    **/

    /**
    Scope events
    **/

    deregistrationCallbackList.push(
      $scope.$on('$ionicView.afterEnter', function(){
        $ionicHistory.clearHistory();
      })
    );

    // cleanup
    $scope.$on('$destroy', function(){
      $http.get(constantConfig.apiUrl + 'notifications/'+uuid+'/read');
      angular.forEach(
        deregistrationCallbackList,
        function(deregistrationCallback){
          deregistrationCallback();
      });
      deregistrationCallbackList = null;
    });

    $scope.$on("$ionicView.beforeEnter", function(event, data){
      $ionicLoading.show({
        template: '<ion-spinner icon="ripple" class="spinner-assertive"></ion-spinner>',
        animation: 'fade-in',
        showBackdrop: true,
      });
      $http
        .get(constantConfig.apiUrl + 'notifications/' + uuid)
        .then(function successCallback(response) {
          self.status = response['data']['status'];
          $scope.notifications = response['data']['notifications'];
        }, function errorCallback() {
          $scope.notifications = [];
        }).finally(function () {
          $ionicLoading.hide();
        });
    });

    /**
    End Scope events
    **/
  }

  angular.module('starter')
    .controller('NotificationController', NotificationController);
})(angular);
