# TP: introduction à Git

Bienvenu à toi, lecteur ! Ce TP a pour objectif de t'aider à prendre en main Git en mettant les mains dans le cambouis. Mais surtout pas de panique si tu n'as jamais utilisé Git ! Ce TP reprend tout de plus le début, mais a été pensé pour faire suite à une (courte) présentation théorique. Je te conseille de consulter les slides disponibles [ici](https://viarezo.fr/formations) avant de te lancer dans ce TP.

## Prérequis

Pour pouvoir faire ce TD, il te faudra le logiciel Git installé sur ton ordinateur :
* Si tu es sous Linux ou Mac, git est normalement déjà installé.
* Si tu es sous Windows, je te conseille d'installer [GitBash](https://gitforwindows.org/). Tu peux aussi utiliser [WSL2](https://www.thomasmaurer.ch/2019/06/install-wsl-2-on-windows-10/) qui est plus complet mais un peu plus compliqué à installer.

Ce TP va aussi utiliser l'éditeur de code [VSCode](https://code.visualstudio.com/). Je te conseille de l'utiliser aussi pour plus de clarté mais tu peux utiliser un autre éditeur de code.

Maintenant que les prérequis sont installés, il est temps de se lancer !


## Partie 0 : Configuration de Git et du Gitlab de ViaRézo

Avant de pouvoir utiliser Git, il y a quelques configuration à faire.

### Ajout d'un nom et email dans Git

Pour que les modifications que tu feras sur le repository soient identifiables, il faut fournir un nom et une adresse email. Pour faire cette configuration, ouvre GitBash (ou un terminal pour Mac/Linux) et entre les commandes suivantes en remplaçant nom et adresse email :

`git config --global user.name "<votre nom>"`

`git config --global user.email "<votre adresse email>"`

Git sait maintenant qui tu es et le nom choisi sera associé aux modifications que tu feras.

### Paramètre de connexion au serveur Gitlab

Lorsque l'on utilise Git, le code est stocké sur un serveur distant, le Gitlab. Dans ce TP, tu utiliseras le Gitlab de ViaRézo, accessible à [cette adresse](https://gitlab.viarezo.fr).

Dans le cas où le projet Gitlab n'est pas public, il faudra s'authentifier pour pouvoir synchroniser les fichiers entre le serveur Gitlab et ton ordinateur. Gitlab propose deux manières de s'authentifier :
* L'indentification par nom d'utilisateur/mot de passe. Par défaut, Gitlab demandera un identifiant (de la forme 2016vandammejc) et un mot de passe lorsque ce sera nécessaire.
* Il n'est pas très confortable de devoir entrer à chaque fois identifiant et mot de passe. Il existe alors une deuxième méthode pour s'authentifier : le protocole ssh. Si cette solution t'intéresse, je t'invite à regarder l'encadré suivant pour la mettre en place.

---
**Optionnel : Paramétrer l'authentification par clé ssh**

* Crée une clé ssh en suivant par exemple [ce tutoriel](https://inchoo.net/dev-talk/how-to-generate-ssh-keys-for-git-authorization/).
* Ajoute ta clé dans ton profil Gitlab en te rendant dans `Settings` (disponibles après avoir cliqué sur le logo en haut à droite) puis `SSH Keys`.
* Tu pourras maintenant t'authentifier via SSH.

![ajout d'une clé ssh dans les paramètres](photos/ssh_key.png)

---

Tout est maintenant configuré, on peut entrer dans le vif du sujet !


## Partie 1 : Fork et Repository

La première étape est de créer un repo Git (c'est-à-dire un endroit pour mettre le code). Au lieu de créer un repo vide, nous allons plutôt découvir une nouvelle opération : **le fork**.

### Fork du projet formation

---
**Qu'est-ce que forker un projet ?**

Lorsqu'un projet disponible en open source sur un Gitlab nous intéresse, on peut en créer une copie et travailler dessus. Ça évite de recommencer un projet de zéro. Il est important de noter que le fork est plus qu'une copie d'un projet puisque le projet source et le projet forkés sont toujours liés. Mais nous n'utiliserons pas ce lien dans ce TP.

---

C'est l'heure de créer ton premier fork. Rendez-vous sur [ce projet Gitlab](https://gitlab.viarezo.fr/ViaRezo/formation-git) pour en créer un fork :
* Sur la page d'accueil du projet, clique sur ***Fork*** en haut à droite au-dessus de la liste des fichiers.
* Il faut alors choisir un namespace (c'est à dire un endroit) où sera stocké le projet. Clique sur le bouton ***Select*** sous ton profil afin de créer un projet personnel.
* Après un temps de chargement, ton projet personnel apparaît. Tu peux vérifier que c'est bien le tiens en regardant dans l'url. Il devrait y avoir ton nom d'utilisateur.
* Comme tu viens de faire un fork, il est encore possible de faire des modifications sur ton projet et sur le projet original. Il faut donc désactiver cette option pour avoir un projet indépendant. Clique sur ***Settings*** dans la barre de gauche puis dans la sous-catégorie ***Advanced***, clique ***Remove fork relationship***. Confirme l'opération en entrant le nom du projet.

Félicitations, tu as maintenant un projet indépendant dans lequel tu feras la suite du TP !! Il ne reste plus qu'à récupérer une copie local (c'est à dire sur ton ordinateur) des fichiers.

### Clone du repo

* Sur la page d'accueil de ton projet, clique sur le bouton ***clone*** et copie le lien pour cloner avec `HTTPS` (sauf si tu suivi l'étape pour paramétrer l'authentification par `SSH`).
* Ouvre un GitBash (Windows) ou un terminal (Mac et Linux) à l'endroit où tu veux enregistrer les fichiers du repo git.
* Entre la commande `git clone <lien copié>`. Git va alors créer un dossier et téléchargement le contenu du projet sur le serveur. Tu as maintenant une copie locale du code !

![lien pour clone le repo](photos/clone.png)

---
**[!] Je n'y parviens pas car Git a mémorisé un mauvais mot de passe [!]**

Windows a mémorisé le mot de passe. Jette un oeil à [cette procédure](https://stackoverflow.com/questions/15381198/remove-credentials-from-git) pour le modifier.

---

## Partie 2 : Versionnage et Premiers commits

Maintenant que tu as une copie locale des fichiers, tu peux commencer à les éditer localement (avant d'envoyer tes modifications sur le serveur). Pour cela, ouvre VSCode et fait ***File > Open Folder***. Sélectionne le dossier `formation-git` fraichement créé. Tu auras alors accès dans VScode à tous les fichiers du repo.

### Mission 1 : Modifier un fichier

Dans un repo git, l'édition des fichiers se fait comme dans un dossier classique. Mais cette modification en local doit ensuite être synchronisée avec le serveur.

Voici-ci dessous une ligne moche et inutile. Sauras-tu la supprimer ? (Tu peux t'aider de la slide de conclusion pour te guider)

**Cette ligne est moche est inutile, supprime là !**

Bravo pour avoir réussi à supprimer la ligne ! Il existe aussi un module git intégré à VSCode, je t'encourage à essayer de l'utiliser pour supprimer la deuxième ligne moche et inutile ci-dessous.

**Cette ligne est aussi moche et inutile, supprime là !**

Tu peux vérifier que les lignes du fichier ont bien disparu du repo distant via l'interface web de Gitlab. Attention à bien regarder sur ta copie personnelle du projet et pas sur le projet originel.

Merci d'avoir pris le temps de nettoyer ce fichier en enlevant ces lignes en trop ! Tu peux passer à la mission suivante.

### Mission 2 : Ajouter un fichier

Ta deuxième mission est de créer un fichier `solutions.md` à la racine du repo (à coté du `README.md`) et d'y ajouter la démarche que tu as suivie pour réussir la mission précédente.

---
**Remarque**

L'extension de fichier `.md` signifie *Markdown*. Ce format permet de faire un peu de mise en page simple de fichier texte dans un format qui peut être lu et affiché sur l'interface web de Gitlab. Tu peux aussi utiliser le raccourci **Ctrl+Shift+V** pour visualiser ce type de fichier.

---

Une fois le fichier créé, n'oublie pas de créer un commit et de le synchroniser avec le serveur Gitlab !

### Mission 3 : Supprimer un fichier

Dernière mission pour la route, il y a dans le repo un fichier nommé `fichier_inutile`. Sauras-tu le supprimer du repo Gitlab ?

Tu peux vérifier que le fichier a bien disparu du repo distant via l'interface web de Gitlab.

Les quelques commandes que tu viens d'utiliser (`git status`, `git add`, `git commit`, `git pull`, `git push`) sont les commandes que tu utiliseras 95% du temps.

Je t'invite à aller voir le graphe du repo depuis l'interface web disponible dans ***Repository > Graph***. Tu peux y retrouver l'historique de tes commits. Note bien l'importance du message de commit clair qui permet de te souvenir de ce qui a changé entre chaque commit ! On voit bien ici que Git permet de versionner le code facilement. Mais qu'en est-il de la collaboration ?

![example de graphe linéaire](photos/commits_lineaires.png)

## Partie 3 : Collaboration, branches et merge requests

Pour pouvoir travailler séparément sur des features différentes on utilise des branches, cette fonctionnalité est particulièrement pratique pour faire avancer en même temps plusieurs versions du même code qui implémentent des fonctionnalités différentes. D'autant plus qu'on ne veut garder sur la branche master que du code 100% fonctionnel.

### Mission 1 : Créer une branche

* Crée une branche et place toi sur cette nouvelle branche
* Vérifie que cette branche est bien sélectionnée
* Consulte le code python de `code/main.py`. Il remplace des mots courants par leur équivalent smiley.

---
**Je veux exécuter mon code mais j'ai une erreur de module**

Il faut installer le module emoji avec la commande `python3 -m pip install -r requirements.txt`. Cette commande va installer tous les modules python listés dans le fichier `requirements.txt`.

---

* Complète le dictionnaire `wordToEmoji` avec quelques emojis supportés. Tu peux trouver la liste [ici](https://www.webfx.com/tools/emoji-cheat-sheet/).
* Si tu as exécuté le fichier python `code/main.py`, tu as peut être pu remarquer l'apparition du dossier `code/__pycache__`. Ces fichiers ne sont pas intéressants à gitter (car pas nécessaires à l'exécution du fichier `code/main.py`). Il faut donc ajouter un gitignore pour les ignorer : ***crée un fichier nommé*** `.gitignore` ***à la racine du repo*** et ajoute les dossiers et fichiers que tu veux ignorer (ici: `code.__pycache__`).
* Commit et push tes changements. Remarque que le dossier `code/__pycacche__` n'a pas été synchronisé.

---
**Je n'arrive pas à push les changements**

Comme tu as créé une branche en local, Git n'arrive pas à trouver la branche correspondant sur le serveur. Il faut donc la créer avce une option spéciale. **Pas de panique ! Git te donne la commande à copier-coller dans le message d'erreur (les erreurs avec Git sont souvent assez explicite pense bien à les lire en cas de problème).**

---


### Merge requests

Il est temps de rajouter ce changement de code dans la branche principale !

Sur l'interface Web du Gitlab, il y a un menu déroulant sous le nombre de commit permettant de sélectionner une branche. Choisis la branche que tu viens de push. Tu peux y voir tes changements mais ils disparaissent si tu repasses sur la branche master. L'objectif est d'intégrer les changements à master. Il faut pour cela créer une **merge request**.

* À gauche, clique sur le 4ème icon ***Merge Requests*** puis clique sur ***New merge request***.
* Choisis ta branche en tant que ***Source branch*** et master en tant que ***Target branch***. Puis clique sur ***Compare branches and continue***
* Remplis un titre et une description. Tu peux aussi ajouter des labels personnalisés pour catégoriser facilement les merge requests.
* Tout en bas tu trouves 2 onglets : ***Commits*** et ***Changes***. Ils te permettent de voir l'historique et les changements entre les 2 branches.
* Clique ***Create merge request***. La merge request a été créée. il ne reste plus qu'à cliquer sur ***Merge*** pour que les changements soient intégrés à master.

![creation d'une merge request](photos/merge_request_create.png)

---
**Remarque :**

Si plusieurs personnes travaillent sur le même projet, les autres membres du projet peuvent review - c'est à dire relire et tester - les changements avant d'accepter la merge request (en cliquant sur ***Merge***). Il est important qu'il y ait un titre et une description claire pour que ce soit plus facile à review. Ils peuvent aussi laisser des commentaires sur le code.

![review de la merge request](photos/merge_request_overview.png)

![review des changements de la merge request](photos/merge_request_changes.png)

---

Félicitations, tu viens de réussir ta première merge request ! Je t'invite à regarder le graphe accessible dans ***Repository > Graph*** afin de bien comprendre l'historique git que tu viens de créer.

![exemple de graphe avec des branches](photos/commits_branches.png)

### Rebase

Si tu retournes dans l'onglet ***Repository > Branches***, tu verras qu'une branche `branche-a-rebase` est déjà créée. Elle apporte des améliorations au code. Tu vas donc devoir créer une merge request pour cette branche.

Une fois la merge request créée. Tu peux voir sur le résumé de la merge request que la branche `branche-a-rebase` a des commits en retard sur master (_x commits behind target branch_). Suivant les réglages du projet, il possible de force le rebase de la branche à merge avant de pouvoir accepter la merge request. Je conseille d'activer cette option dans le projet Gitlab :

* Dans ***Settings > General > Merge requests***, choisir l'option `Merge commit with semi-linear history`.

Tu peux maintenant revenir dans l'onglet ***Merge requests***.

Comme il y a déjà eu des changements sur le même fichier, il faut **rebase** la branche sur master. Pas de panique, il suffit de cliquer sur le bouton ***Rebase*** sur la page de la merge request. Une fois le rebase effectué, tu peux review le code et merge. Encore, une fois, n'oublie pas de regarder le graphe pour bien visualiser les opérations que tu viens de faire.

## Conclusion

Ça y est c'est la fin de ce TP. Bien sûr il n'a abordé qu'une faible partie de toute la puissance de Git mais j'espère qu'il t'a donné les clés pour survivre à l'utilisation de Git pour les Coding Weeks.

Enfin, dernier conseil : Git réserve parfois quelques situations un peu complexes, notamment lorsque des conflits se créent entre deux modifications. Il faut alors les résoudre à la main (heureusement VSCode aide en affichant les conflits). Mais surtout pas de panique ! Comme dans beaucoup de messages d'erreur, Git donne la démarche à suivre pour résoudre l'erreur dans le message d'erreur. **Il faut donc bien faire attention à ce que Git te communique !**

Sur ce j'espère que tu as apprécié ce TP, il ne me reste plus qu'à te souhaiter une bonne utilisation de Git en Coding Weeks, pour le site de ton asso, ou dans à ViaRézo :wink: !
