import emoji
import sys

wordToEmoji = {
    'super': ':thumbs_up:',
    'coeur': ':red_heart:',
    'sourire': ':smiley:',
}


def translate(word):
    if word in wordToEmoji.keys():
        return wordToEmoji[word]
    else:
        return word


def convert(word):
    # emoji.emojize convertit le code smiley en smileys
    return emoji.emojize(word, use_aliases=True)


if __name__ == "__main__":

    if len(sys.argv) <= 1:
        print("Veuillez entrer une phrase en paramètre.")

    else:
        convertedText = ""
        for sentence in sys.argv[1:]:
            words = sentence.split(" ")
            for word in words:
                convertedText += convert(translate(word)) + " "
        print(convertedText)
