"""
Server module for the web calculator.
"""
from fastapi import FastAPI
from fastapi.requests import Request
from fastapi.templating import Jinja2Templates
from calculator.calculator import Calculator

app = FastAPI()
templates = Jinja2Templates(directory="calculator/templates")
calc = Calculator()

@app.get("/")
async def root(request: Request):
    """
    Default and only route of the web calculator.
    Expects either no query parameters or a single query parameter named "expression".
    """
    expression = request.query_params.get("expression", "")
    context = {"request": request}
    if expression:
        result = calc(expression)
        context = {"request": request,
                   "expression": expression, "result": result}
    return templates.TemplateResponse("index.html", context)
