"""
Operator module contains the Operator class and a list of standard operators.
"""
class Operator:
    """
    Operator class is a binary operator with a symbol, a precedence and an evaluation function.
    """

    def __init__(self, symbol, precedence, evaluate_function):
        self.symbol = symbol
        self.precedence = precedence
        self.evaluate_function = evaluate_function

    def __repr__(self):
        return self.symbol

    def __call__(self, left, right):
        return self.evaluate_function(left, right)


STANDARD_OPERATORS = {
    '+': Operator('+', 1, lambda a, b: a + b),
    '-': Operator('-', 1, lambda a, b: a - b),
    '*': Operator('×', 2, lambda a, b: a * b),
    '/': Operator('/', 2, lambda a, b: a / b),
}
