import React, { useState, useEffect } from 'react';
import axios from 'axios';
import ListeScores from "./MonHumaviron/ListeScores";
import { MDBDataTableV5, MDBContainer, MDBBtn, MDBTable, MDBTableHead, MDBTableBody, MDBDataTable, MDBIcon, MDBListGroup, MDBBadge, MDBListGroupItem, MDBRow, MDBCol } from 'mdbreact';
import eventData from "../../eventData/eventData.json";

export default function MonHumaviron () {

    const [user,setUser] = useState("");
    const [userData,setUserData] = useState({
        dataperf: [],
        distTotale: 0,
        distMax: 0,
        nbScores: 0,
        distMoy: 0,
      });

    useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/user').then((response) => setUser(response.data));
      axios.get(`/api/my_scores?id=${user.login}`).then((response) => setUserData(response.data));
    }, 500);
    return () => clearInterval(interval);
    });
    
    return (
        <MDBContainer className="mt-4">
            <MDBRow>
                <MDBCol md="12">
                <h2><MDBIcon icon="address-card" className="mr-1" /> Ma course</h2>
                <br/>
                </MDBCol>
            </MDBRow>
        <MDBRow>
            <MDBCol md="4">
        <MDBListGroup>
        <MDBListGroupItem active><MDBIcon icon="heart" className="mr-1" /><strong>&nbsp; Participation caritative</strong></MDBListGroupItem>    
            <MDBListGroupItem className="d-flex justify-content-between align-items-center"><MDBIcon icon="tachometer-alt" className="mr-1" /> Nombre total de tours<MDBBadge color="primary"
                pill>{userData.distTotale}</MDBBadge>
            </MDBListGroupItem>
            <MDBListGroupItem className="d-flex justify-content-between align-items-center"><MDBIcon icon="hand-holding-heart" className="mr-1" /> Dons collectés<MDBBadge
                color="primary" pill>{Math.trunc(userData.distTotale*eventData.argentParTour)} €</MDBBadge>
            </MDBListGroupItem>
            </MDBListGroup>
        <br /> 
        <MDBListGroup>
        <MDBListGroupItem active><MDBIcon icon="chart-line" className="mr-1" /><strong>&nbsp;Statistiques personnelles</strong></MDBListGroupItem>    
            {/*<MDBListGroupItem className="d-flex justify-content-between align-items-center"><MDBIcon icon="trophy" className="mr-1" /> Classement individuel<MDBBadge color="primary"
                pill>65e</MDBBadge>
            </MDBListGroupItem>*/}
            <MDBListGroupItem className="d-flex justify-content-between align-items-center"><MDBIcon icon="clipboard-list" className="mr-1" /> Nombre de sessions<MDBBadge color="primary"
                pill>{userData.nbScores}</MDBBadge>
            </MDBListGroupItem>
            <MDBListGroupItem className="d-flex justify-content-between align-items-center"><MDBIcon icon="angle-double-up" className="mr-1" /> Meilleure session<MDBBadge
                color="primary" pill>{userData.distMax} tours</MDBBadge>
            </MDBListGroupItem>
            <MDBListGroupItem className="d-flex justify-content-between align-items-center"><MDBIcon icon="flag-checkered" className="mr-1" /> Performance moyenne/session<MDBBadge color="primary"
                pill>{Math.trunc(userData.distMoy)} tours</MDBBadge>
            </MDBListGroupItem>
            </MDBListGroup> 
            </MDBCol>
            <MDBCol md="8">
                <ListeScores data={userData.dataperf}/>
            </MDBCol>
            </MDBRow>
            <MDBRow>
                <br />
                <p> </p>
            </MDBRow>  
        </MDBContainer>
    );
}