import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function AddScoreForm() {

  const addScore = (props) => {
    axios.post('/api/staff/new_score',
      {
        score: props.score,
        equipe: props.equipe,
        participant: props.participant
      })
      .then(() => {
        alert("Score ajouté");
        window.location = '/Gestion';
      }, (error) => {
        console.log(error);
      });
  };


  const [equipes, setEquipes] = useState([]);
  const [participants, setParticipants] = useState([]);

  useEffect(() => { axios.get('/api/equipes').then((response) => setEquipes(response.data)) }, []);
  useEffect(() => { axios.get('/api/participants').then((response) => setParticipants(response.data)) }, []);

  const { register, handleSubmit } = useForm();
  const onSubmit = data => { addScore(data) }
  return (
    <div>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="scoreInput">Score</label>
          <input type="number" className="form-control" id="scoreInput" name="score" ref={register} placeholder="1000" required />
        </div>
        <div className="form-group">
          <label htmlFor="participantInput">Participant</label>
          <select className="form-control" id="participantInput" name="participant" ref={register} placeholder="Gérard">
            {participants.map(item => (<option key={item.id} value={item.id}>{item.name}</option>))}
          </select>
        </div>
        <div className="form-group">
          <label htmlFor="equipeInput">Equipe</label>
          <select className="form-control" id="equipeInput" name="equipe" ref={register} placeholder="ViaRézo">
            {equipes.map(item => (<option key={item.id} value={item.id}>{item.name}</option>))}
          </select>
        </div>
        <button type="submit" className="btn btn-secondary">Ajouter</button>
      </form>
    </div>
  )
}
