import React from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function UpdateParticipant({ match }){

  const { params: { id } } = match;

  const editParticipant = (props) => {
    axios.post('/api/admin/update_participant',{id: props.id, name:props.name})
    .then(() => {
      alert('Participant mis à jour');
      window.location='/admin/participants/'
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editParticipant({id:id,name:data.name})}

  return(
    <div>
      <a className="btn btn-secondary" href="/admin/participants" role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="nameInput">Nom</label>
          <input type="text" className="form-control" id="nameInput" name="name" ref={register}/>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )

}
