import React from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function AddObjectifForm(){

  const addObjectif = (props) => {
    axios.post('/api/admin/new_objectif',
    {
        name: props.name,
        description: props.description,
        value: props.value,
        coef: props.coef
    })
    .then(() => {
      alert("Objectif ajouté");
      window.location='/admin/objectifs';
    }, (error) => {
      console.log(error);
    });
  };


  const { register, handleSubmit } = useForm();
  const onSubmit = data => {addObjectif(data)}
  return(
  <div>
    <a className="btn btn-secondary" href="/admin/objectifs" role="button">Retour</a>
    <form onSubmit={handleSubmit(onSubmit)}>
      <div className="form-group">
        <label htmlFor="nameInput">Nom</label>
        <input type="text" className="form-control" id="nameInput" name="name" ref={register} placeholder="Objectif Lune" required/>
      </div>
      <div className="form-group">
        <label htmlFor="descriptionInput">Description</label>
        <textarea className="form-control" id="descriptionInput" rows="3" name="description" ref={register} placeholder="Description de l'objectif" ></textarea>
      </div>
      <div className="form-group">
        <label htmlFor="valueInput">Objectif</label>
        <input type="number" className="form-control" id="valueInput" name="value" ref={register} placeholder="10000" required/>
      </div>
      <div className="form-group">
        <label htmlFor="coefInput">Coefficient</label>
        <input type="float" className="form-control" id="coefInput" name="coef" ref={register} placeholder="1"/>
      </div>
      <button type="submit" className="btn btn-secondary">Ajouter</button>
    </form>
  </div>
  )
}
