import React, { useState, useEffect } from 'react';
import axios from 'axios';

export function TableauEvenementsAdmin(){
  var [evenements,setEvenements] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/admin/admin_evenements').then((response) => setEvenements(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  return(
    <table className="table">
      <thead className="thead-light">
        <tr>
          <th scope="col">Nom</th>
          <th scope="col">Date de début</th>
          <th scope="col">Date de fin</th>
          <th scope="col">Voir</th>
          <th scope="col">Supprimer</th>
        </tr>
      </thead>
      <tbody>
        {evenements.map((item) => {
          var viewUrl='/admin/evenements/view/'+item.id;
          var deleteUrl='/admin/evenements/delete/'+item.id;
          return (
          <tr key={item.id}>
            <th scope="row">{item.name}</th>
            <td>{item.startDate.split('T')[0]} - {item.startDate.split('T')[1].split('.')[0]}</td>
            <td>{item.endDate.split('T')[0]} - {item.endDate.split('T')[1].split('.')[0]}</td>
            <td><a className="btn btn-secondary" href={viewUrl} role="button">Voir</a></td>
            <td><a className="btn btn-danger" href={deleteUrl} role="button">Delete</a></td>
          </tr>
          )
        })}
      </tbody>
    </table>
  )
}
