import React from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function AddEvenementForm(){

  const addEvenement = (props) => {
    axios.post('/api/admin/new_evenement',
    {
        name: props.name,
        startDate: props.startDate,
        endDate: props.endDate
    })
    .then(() => {
      alert("Evenement ajouté");
      window.location='/admin/evenements';
    }, (error) => {
      console.log(error);
    });
  };


  const { register, handleSubmit } = useForm();
  const onSubmit = data => {addEvenement(data)}
  return(
  <div>
    <a className="btn btn-secondary" href="/admin/evenements" role="button">Retour</a>
    <form onSubmit={handleSubmit(onSubmit)}>
      <div className="form-group">
        <label htmlFor="nameInput">Nom</label>
        <input type="text" className="form-control" id="nameInput" name="name" ref={register} required/>
      </div>
      <div className="form-group">
        <label htmlFor="startDateInput">Date de début</label>
        <input type="datetime-local" className="form-control" id="startDateInput" name="startDate" ref={register} required></input>
      </div>
      <div className="form-group">
        <label htmlFor="endDateInput">Date de fin</label>
        <input type="datetime-local" className="form-control" id="endDateInput" name="endDate" ref={register} required/>
      </div>
      <button type="submit" className="btn btn-secondary">Ajouter</button>
    </form>
  </div>
  )
}
