import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function AfficheEvenement({ match }){

  const { params: { id } } = match;

  const [evenements, setEvenements] = useState([]);
  useEffect(() => {axios.get('/api/admin/admin_evenements').then((response) => setEvenements(response.data))}, []);
  const [currentEvenement, setCurrentEvenement] = useState({});
  useEffect(() => {
    evenements.map(item => {
      if (item.id==id) {setCurrentEvenement(item)}
      return null;
    })
  });

  var editNameUrl='/admin/evenements/edit/name/'+id;
  var editStartDateUrl='/admin/evenements/edit/startdate/'+id;
  var editEndDateUrl='/admin/evenements/edit/enddate/'+id;
  return(
    <div>
      <h1>Modification événement</h1>
      <a className="btn btn-secondary" href="/admin/evenements" role="button">Retour</a>
      <table className="table">
        <thead className="thead-light">
          <tr>
            <th scope="col">Champ</th>
            <th scope="col">Valeur</th>
            <th scope="col">Action</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <th scope="row">Nom</th>
            <td>{currentEvenement.name}</td>
            <td><a className="btn btn-secondary" href={editNameUrl} role="button">Modifier</a></td>
          </tr>
          <tr>
            <th scope="row">Date de début</th>
            <td>{currentEvenement.startDate}</td>
            <td><a className="btn btn-secondary" href={editStartDateUrl} role="button">Modifier</a></td>
          </tr>
          <tr>
            <th scope="row">Date de fin</th>
            <td>{currentEvenement.endDate}</td>
            <td><a className="btn btn-secondary" href={editEndDateUrl} role="button">Modifier</a></td>
          </tr>
        </tbody>
      </table>
    </div>
  )
}

export function UpdateEvenementName({ match }){

  const { params: { id } } = match;

  const editName = (props) => {
    axios.post('/api/admin/update_evenement/name',{id: props.id, name:props.name})
    .then(() => {
      alert('Nom mis à jour');
      window.location='/admin/evenements/view/'+id;
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editName({id:id,name:data.name})}

  const returnUrl = "/admin/evenements/view/"+id;

  return(
    <div>
      <a className="btn btn-secondary" href={returnUrl} role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="nameInput">Nom</label>
          <input type="text" className="form-control" id="nameInput" name="name" ref={register}/>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )
}

export function UpdateEvenementStartDate({ match }){

  const { params: { id } } = match;

  const editStartDate = (props) => {
    axios.post('/api/admin/update_evenement/startdate',{id: props.id, startDate:props.startDate})
    .then(() => {
      alert('Date de début mise à jour');
      window.location='/admin/evenements/view/'+id;
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editStartDate({id:id, startDate:data.startDate})}

  const returnUrl = "/admin/evenements/view/"+id;

  return(
    <div>
      <a className="btn btn-secondary" href={returnUrl} role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div clasNames="form-group">
          <label htmlFor="startDateInput">Date de début</label>
          <input type="datetime-local" className="form-control" id="startDateInput" name="startDate" ref={register}></input>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )
}

export function UpdateEvenementEndDate({ match }){

  const { params: { id } } = match;

  const editEndDate = (props) => {
    axios.post('/api/admin/update_evenement/enddate',{id: props.id, endDate:props.endDate})
    .then(() => {
      alert('Date de fin mise à jour');
      window.location='/admin/evenements/view/'+id;
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editEndDate({id:id, endDate:data.endDate})}

  const returnUrl = "/admin/evenements/view/"+id;

  return(
    <div>
      <a className="btn btn-secondary" href={returnUrl} role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="endDateInput">Date de fin</label>
          <input type="datetime-local" className="form-control" id="endDateInput" name="endDate" ref={register}/>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )
}
