import React, { useState, useEffect } from 'react';
import axios from 'axios';

export function TableauEquipesAdmin(){
  var [equipes,setEquipes] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/equipes').then((response) => setEquipes(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  return(
    <table className="table">
      <thead className="thead-light">
        <tr>
          <th scope="col">Id</th>
          <th scope="col">Equipe</th>
          {/*<th scope="col">Modifier</th>*/}
          <th scope="col">Supprimer</th>
        </tr>
      </thead>
      <tbody>
        {equipes.map((item) => {
          var editUrl='/admin/equipes/edit/'+item.id;
          var deleteUrl='/admin/equipes/delete/'+item.id;
          return (
          <tr key={item.id}>
            <th scope="row">{item.id}</th>
            <th scope="row">{item.name}</th>
            {/*<td><a className="btn btn-secondary" href={editUrl} role="button">Modifier</a></td>*/}
            <td><a className="btn btn-danger" href={deleteUrl} role="button">Supprimer</a></td>
          </tr>
          )
        })}
      </tbody>
    </table>
  )
}
