import React from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function AddEquipeForm(){

  const addEquipe = (props) => {
    axios.post('/api/admin/new_equipe',
    {
        name: props.name
    })
    .then(() => {
      alert("Equipe ajoutée");
      window.location='/Gestion';
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {addEquipe(data)}
  return(
  <div>
    <form onSubmit={handleSubmit(onSubmit)}>
      <div className="form-group">
        <label htmlFor="nameInput">Nom</label>
        <input type="text" className="form-control" id="nameInput" name="name" ref={register} placeholder="Nom" required/>
      </div>
      <button type="submit" className="btn btn-secondary">Ajouter</button>
    </form>
  </div>
  )
}
