import React from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function UpdateEquipe({ match }){

  const { params: { id } } = match;

  const editEquipe = (props) => {
    axios.post('/api/admin/update_equipe',{id: props.id, name:props.name})
    .then(() => {
      alert('Equipe mise à jour');
      window.location='/Gestion'
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editEquipe({id:id,name:data.name})}

  return(
    <div>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="nameInput">Nom</label>
          <input type="text" className="form-control" id="nameInput" name="name" ref={register}/>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )

}
