import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { MDBContainer, MDBRow, MDBCol, MDBIcon, MDBBtn } from "mdbreact";
import '../../../index.css';
import ClassIndiv from '../ClassementIndividuel';
import ClassEquipe from '../ClassementEquipe';
import CircularCountdown from './Countdown';
import ProgressBar from '../ProgressBar'
import eventData from "../../../eventData/eventData.json";

const Leaderboard = () => {

  var [distanceTotale,setDistanceTotale] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/distance_totale').then((response) => setDistanceTotale(response.data[0].distanceTotale));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  var [nombreParticipants,setNombreParticipants] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/nombre_participants').then((response) => setNombreParticipants(response.data[0].nombreParticipants));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  return (
      <MDBContainer className="mt-4">
      <MDBRow>
        <MDBCol size="6"><CircularCountdown/></MDBCol>
        <MDBCol middle size="6">
          <MDBRow>
            &nbsp;
          </MDBRow>  
          <MDBRow>
            <MDBCol middle size="4"><MDBBtn rounded color="primary" size="md"><MDBIcon icon="user-alt" className="mr-1" size="1x" /> {nombreParticipants}</MDBBtn></MDBCol>
            <MDBCol middle size="4"><MDBBtn rounded color="primary" size="md"><MDBIcon icon="redo-alt" className="mr-1" size="1x" /> {distanceTotale}</MDBBtn></MDBCol>
            <MDBCol middle size="4"><MDBBtn rounded color="primary" size="md"><MDBIcon icon="hand-holding-usd" className="mr-1" size="1x" /> {Math.min(Math.trunc(distanceTotale*eventData.argentParTour),eventData.plafondArgent)} €</MDBBtn></MDBCol>
          </MDBRow>
        </MDBCol>
        </MDBRow>
        <MDBRow>
            &nbsp;
        </MDBRow>
      <MDBRow>
        <MDBCol size="12"><ProgressBar /></MDBCol>
       </MDBRow> 
        <MDBRow>
          &nbsp;
        </MDBRow>
        <MDBRow>
          <MDBCol size="6"><h2><MDBIcon icon="user-alt" className="mr-1" /> Individuel</h2><ClassIndiv/></MDBCol>
          <MDBCol size="6"><h2><MDBIcon icon="users" className="mr-1" /> Associations</h2><ClassEquipe/></MDBCol>
        </MDBRow>
        <MDBRow>
          <br />
        </MDBRow>
      </MDBContainer>
  );
}

export default Leaderboard;