import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { MDBTable, MDBTableBody, MDBTableHead } from 'mdbreact';

const BasicTable = () => {

  var [participants,setParticipants] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/classement_individuel').then((response) => setParticipants(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  var i = 1;
  const size = 10;

  return (
    <MDBTable small hover bordered responsiveLg >
      <MDBTableHead color="blue-gradient" textWhite>
        <tr>
          <th>#</th>
          <th>Coureuse/Coureur</th>
          <th>Association(s)</th>
          <th>Tours</th>
        </tr>
      </MDBTableHead>
      <MDBTableBody>
      {participants.slice(0,size).map((item) =>
        <tr>
          <td>{i++}</td>
          <td>{item.name}</td>
          <td>{item.equipes.join(", ")}</td>
          <td>{item.score}</td>
        </tr>
        )}
      </MDBTableBody>
      </MDBTable>
  );
}

export default BasicTable;