import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { MDBDataTableV5 } from 'mdbreact';

export default function ClassSprint() {

  var data = [];
  var [participants,setParticipants] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/sprint').then((response) => setParticipants(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  function RefreshData() {
    var i = 1;
    participants.map((item) => 
    data.push(
      {
        rank: i++,
        association: item.name,
        points: item.score,
      },
    )
  );
  return({
    columns: [
      {
        label: '# Rang',
        field: 'rank',
        sort: 'disabled',
        width: 100,
      },
      {
        label: 'Association',
        field: 'association',
        width: 150,
        sort: 'disabled',
        attributes: {
          'aria-controls': 'DataTable',
          'aria-label': 'Association',
        },
      },
      {
        label: 'Points',
        field: 'points',
        sort: 'disabled',
        width: 100,
      },
    ],
    rows: data})
  }


  return (<>
  <br/><br/>
  <MDBDataTableV5 paging={false} hover searchTop={true} searchBottom={false} striped info={false} data={RefreshData()} searchLabel="Rechercher" responsiveLg />
  </>);
}