import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { MDBDataTableV5 } from 'mdbreact';

export default function ClassIndiv() {

  var data = [];
  var [participants,setParticipants] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/classement_individuel').then((response) => setParticipants(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  function RefreshData() {
    var i = 1;
    participants.map((item) => 
    data.push(
      {
        rank: i++,
        nom: item.name,
        assos: item.equipes.join(", "),
        tours: item.score,
        sessions: item.nbScores
      },
    ), 
  );
  return({
    columns: [
      {
        label: '# Rang',
        field: 'rank',
        sort: 'disabled',
        width: 100,
      },
      {
        label: 'Coureuse/Coureur',
        field: 'nom',
        width: 250,
        sort: 'disabled',
        attributes: {
          'aria-controls': 'DataTable',
          'aria-label': 'Association',
        },
      },
      {
        label: 'Association(s)',
        field: 'assos',
        sort: 'disabled',
        width: 100,
      },
      {
        label: 'Tours',
        field: 'tours',
        sort: 'disabled',
        width: 100,
      },
      /*{
        label: 'Dons rapportés',
        field: 'dons',
        sort: 'disabled',
        width: 100,
      },*/
      {
        label: 'Sessions',
        field: 'sessions',
        sort: 'disabled',
        width: 100,
      },
    ],
    rows: data})
  }

  return (<>
  <br/><br/>
  <MDBDataTableV5 paging={false} hover searchTop={true} searchBottom={false} striped info={false} data={RefreshData()} searchLabel="Rechercher" responsiveLg />
  </>);
}