import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { MDBDataTableV5 } from 'mdbreact';

export default function ClassEquipe() {

  var data = [];
  var [participants,setParticipants] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/classement_par_equipes').then((response) => setParticipants(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  function RefreshData() {
    var i = 1;
    participants.map((item) => 
    data.push(
      {
        rank: i++,
        association: item.name,
        tours: item.score,
        relais: item.nbScores,
        coureurs: item.nbParticipant
      },
    )
  );
  return({
    columns: [
      {
        label: '# Rang',
        field: 'rank',
        sort: 'disabled',
        width: 100,
      },
      {
        label: 'Association',
        field: 'association',
        width: 150,
        sort: 'disabled',
        attributes: {
          'aria-controls': 'DataTable',
          'aria-label': 'Association',
        },
      },
      {
        label: 'Tours',
        field: 'tours',
        sort: 'disabled',
        width: 100,
      },
      {
        label: 'Nombre de relais',
        field: 'relais',
        sort: 'disabled',
        width: 100,
      },
      {
        label: 'Nombre de coureurs',
        field: 'coureurs',
        sort: 'disabled',
        width: 100,
      },
    ],
    rows: data})
  }


  return (<>
  <br/><br/>
  <MDBDataTableV5 paging={false} hover searchTop={true} searchBottom={false} striped info={false} data={RefreshData()} searchLabel="Rechercher" responsiveLg />
  </>);
}