import React from 'react';
import { MDBBtn, MDBCard, MDBCardBody, MDBCardImage, MDBCardTitle, MDBCardText, MDBRow, MDBCol, MDBView, MDBIcon } from 'mdbreact';
import FACSLogo from "./FACS.svg";
import PICSLogo from "./PICS.png";

const CardExample = () => {
  return (
    <MDBRow>
      <MDBCol md='4'>
        <MDBCard wide cascade>
          <MDBView cascade>
            <MDBCardImage
              hover
              overlay='white-slight'
              className='card-img-top'
              src={FACSLogo}
              alt='Card cap'
            />
          </MDBView>

          <MDBCardBody cascade className='text-center'>
            <MDBCardTitle className='card-title'>
              <strong>FACS</strong>
            </MDBCardTitle>

            <p className='font-weight-bold blue-text'>Association étudiante</p>

            <MDBCardText>
              La FACS contribue à la vie des associations de l'école.
              Annuellement, elle accorde une CheerUp ! pour la semaine 
              contre le cancer.{' '}
            </MDBCardText>

            <MDBCol md='12' className='d-flex justify-content-center'>
              <a href='https://www.facebook.com/federationACS/' className='px-2 fa-lg fb-ic'>
                <MDBIcon fab icon='facebook-f'></MDBIcon>
              </a>
              <a href="https://fr.linkedin.com/company/federation-des-associations-de-centralesupelec" className='px-2 fa-lg fb-ic'>
                <MDBIcon fab icon='linkedin-in'></MDBIcon>
              </a>
            </MDBCol>
          </MDBCardBody>
        </MDBCard>
        <br/>
      </MDBCol>

      <MDBCol md='4'>
        <MDBCard wide cascade>
          <MDBView cascade>
            <MDBCardImage
              hover
              overlay='white-slight'
              className='card-img-top'
              src={PICSLogo}
              alt='Card cap'
            />
          </MDBView>

          <MDBCardBody cascade className='text-center'>
            <MDBCardTitle className='card-title'>
              <strong>PICS</strong>
            </MDBCardTitle>

            <p className='font-weight-bold blue-text'>Association étudiante</p>

            <MDBCardText>
            PICS contribue à la vie associative du campus. Nous les 
            remercions pour assurer la couverture photo de cet événement. {' '}
            </MDBCardText>

            <MDBCol md='12' className='d-flex justify-content-center'>
              <a href='https://www.linkedin.com/company/picscentralesupelec/' className='px-2 fa-lg li-ic'>
                <MDBIcon fab icon='linkedin-in'></MDBIcon>
              </a>

              <a href='https://twitter.com/galerie_pics' className='px-2 fa-lg tw-ic'>
                <MDBIcon fab icon='twitter'></MDBIcon>
              </a>

              <a href='https://galerie.pics/' className='px-2 fa-lg fb-ic'>
                <MDBIcon icon='globe'></MDBIcon>
              </a>

              <a href='https://www.facebook.com/picscentralesupelec/' className='px-2 fa-lg fb-ic'>
                <MDBIcon fab icon='facebook-f'></MDBIcon>
              </a>

              <a href='https://www.instagram.com/pics.centralesupelec/' className='px-2 fa-lg fb-ic'>
                <MDBIcon fab icon='instagram'></MDBIcon>
              </a>
            </MDBCol>
          </MDBCardBody>
        </MDBCard>
        <br/>
      </MDBCol>

      {/* <MDBCol md='4'>
        <MDBCard wide cascade>
          <MDBView cascade>
            <MDBCardImage
              hover
              overlay='white-slight'
              className='card-img-top'
              src={CVECLogo}
              alt='Card cap'
            />
          </MDBView>

          <MDBCardBody cascade className='text-center'>
            <MDBCardTitle className='card-title'>
              <strong>CVEC</strong>
            </MDBCardTitle>

            <p className='font-weight-bold blue-text'>Organisation publique</p>

            <MDBCardText>
              La <i>Contribution de Vie Etudiante et de Campus</i> participe 
              aux projets associatifs étudiants. Cete année, elle accompagne HumaCS
              via une subvention couvrant les frais de l'évènement.{' '}
            </MDBCardText>
            

          </MDBCardBody>
        </MDBCard>
        <br/>
      </MDBCol> */}
    </MDBRow>
  )
}

export default CardExample;