import React, { Component, useState } from "react";
import { MDBNavbar, MDBNavbarBrand, MDBNavbarNav, MDBNavItem, MDBNavLink, MDBNavbarToggler, MDBCollapse} from "mdbreact";
import Dropdown from "./Dropdown";
import axios from 'axios';

export default function NavigationBar (props){


  const [user, setUser] = useState({});
  const [initialize, setInitialize] = useState(true);
  if (initialize) {
    axios.get('/api/user').then((response) => setUser(response.data));
    setInitialize(false);
  }

  var px;
  if (window.screen.width > 767) {
    px = "30";
  }
  else {
    px = "25";
  }

//render() {
  return (
    <>
      <MDBNavbar color="blue-gradient" dark expand="md">
        <MDBNavbarBrand href="/">
        <img src="../../logo-cheer-up.png" alt="Logo Cheer Up!" height={px}/>
        </MDBNavbarBrand>
        <MDBNavbarToggler onClick={props.toggle.toggleCollapse} />
        <MDBCollapse id="navbarCollapse3" isOpen={props.toggle.state.isOpen} navbar>
          <MDBNavbarNav left>
            <MDBNavItem active>
              <MDBNavLink to="/">Leaderboard</MDBNavLink>
            </MDBNavItem>
            <MDBNavItem>
              <MDBNavLink to="/Classement">Classement</MDBNavLink>
            </MDBNavItem>
            <MDBNavItem>
              <MDBNavLink to="/Partenaires">Partenaires</MDBNavLink>
            </MDBNavItem>
            <MDBNavItem>
              <MDBNavLink to="/CheerUp">Cheer Up!</MDBNavLink>
            </MDBNavItem>
          </MDBNavbarNav>
          <MDBNavbarNav right>
            <MDBNavItem>
              <Dropdown user={user} />
            </MDBNavItem>
          </MDBNavbarNav>
        </MDBCollapse>
      </MDBNavbar>
      </>
    );
  }
;